function Bitmap(grid, left, top, cellWidth, cellHeight, hSpacing, vSpacing) {
	this.left								= left;
	this.top								= top;
	this.align							= 'left';
	this.cellWidth					= cellWidth;
	this.cellHeight					= cellHeight;
	this.hSpacing						= hSpacing;
	this.vSpacing						= vSpacing;
	this.grid								= grid;
	
	this.paint							= Bitmap_paint;
	this.addPixel						= Bitmap_addPixel;
	this.getBounds					= Bitmap_getBounds;
	this.getColumnCount			= Bitmap_getColumnCount;
	this.getRowCount				= Bitmap_getRowCount;
	this.getPixelCount			= Bitmap_getPixelCount;
	this.show								= Bitmap_show;
}

function Bitmap_paint(show) {
	var i, item, c, u, v;
	
	v = 0;
	u = 0;
	this.items = new Array();
	for (i = 0; i < this.grid.length; i++) {
		c = this.grid.substr(i, 1);
		if (c == 'x') {
			item = this.addPixel(u, v, show);
			u++;
		}
		else if (c == '\n') {
			v++;
			u = 0;
		}
		else {
			u++;
		}
	}
}

function Bitmap_show(show) {
	for (var i = 0; i < this.items.length; i++) {
		this.items[i].style.visibility = show ? 'visible' : 'hidden';
	}
}

function Bitmap_addPixel(u, v, show) {
	var item = document.createElement('DIV');
	item.innerHTML = '<img src="../stars/blank.gif" width=1 height=1>';
	item.style.position = 'absolute';
	item.style.pixelWidth = 15;
	item.style.pixelHeight = 15;
	item.style.pixelLeft = this.left + u*(this.cellWidth+this.hSpacing);
	item.style.pixelTop = this.top + v*(this.cellHeight+this.vSpacing);
	item.style.backgroundColor = 'blue';
	item.style.visibility = show ? 'visible' : 'hidden';
	item.u = u;
	item.v = v;

	this.items[this.items.length] = item;
	document.body.appendChild(item);
	return item;
}

function Bitmap_getBounds() {

}

function Bitmap_getColumnCount() {
	var cols, i, c;

	cols = 0;
	c = 0;
	for (i = 0; i < this.grid.length; i++) {
		if (this.grid.substr(i, 1) == '\n') {
			if (c > cols) {
				cols = c;
			}
			c = 0;
		}
		else {
			c++;
		}
	}
	
	return cols;
}

function Bitmap_getRowCount() {
	var rows, i, nextRow;
	
	rows = 1;
	nextRow = 0;
	for (i = 0; i < this.grid.length; i++) {
		if (nextRow == 1) {
			nextRow = 0;
			rows++;
		}
		if (this.grid.substr(i, 1) == '\n') {
			nextRow = 1;
		}
	}
	
	return rows;
}

function Bitmap_getPixelCount() {
	var i, count;
	
	count = 0;
	for (i = 0; i < this.grid.length; i++) {
		if (this.grid.substr(i, 1) == 'x') { count++; }
	}
	
	return count;
}

var BitmapMorphCount = 0;

function BitmapMorph(source, target, speed) {
	this.id								= BitmapMorphCount++;
	this.source 					= source;
	this.target 					= target;
	this.speed						= speed;
	this.step							= null;
	
	this.play							= BitmapMorph_play;
	this.finish						= BitmapMorph_finish;
	this.nextStep					= BitmapMorph_nextStep;
	
	makeEventDispatcher(this);
	this.fireOnStop				= BitmapMorph_fireOnStop;
	this.fireOnPlay				= BitmapMorph_fireOnPlay;

	eval('window.BitmapMorph'+this.id+' = this;');
}

function BitmapMorph_play() {
	var i, j, si, ti, sp1, sp2, r, diff;
	
	this.step = 0;
	si = this.source.items;
	ti = this.target.items;

	sp1 = new Array();
	for (j = 0; j < ti.length; j++) {
		sp1[j] = ti[j];
	}

	// generate additional pixels if target has more than source
	diff = ti.length - si.length;
	if (diff > 0) {
		for (i = 0; i < diff; i++) {
			this.source.addPixel(si[i].u, si[i].v, true);
		}
	}

	// generate random-ordered array of target items
	spots = new Array();
	for (j = 0; j < ti.length; j++) {
		r = Math.floor(Math.random()*(sp1.length));
		spots[j] = sp1[r];
		sp2 = sp1.slice(0, r);
		sp1 = sp2.concat(sp1.slice(r+1, sp1.length));
	}
	
	for (i = 0; i < si.length; i++) {
		si[i].morphX1 = si[i].style.pixelLeft;
		si[i].morphY1 = si[i].style.pixelTop;
		si[i].morphX2 = spots[i%spots.length].style.pixelLeft;
		si[i].morphY2 = spots[i%spots.length].style.pixelTop;
	}

	this.fireOnPlay();
	this.nextStep();
}

function BitmapMorph_nextStep() {
	var i, si, step;
	
	step = this.step;
	if (step > 100) { step = 100; }
	
	si = this.source.items;	
	for (i = 0; i < si.length; i++) {
		si[i].style.pixelLeft = si[i].morphX1+(si[i].morphX2-si[i].morphX1)*(step/100);
		si[i].style.pixelTop = si[i].morphY1+(si[i].morphY2-si[i].morphY1)*(step/100)
	}

	if (step < 100) {
		this.step += this.speed;
		window.setTimeout('window.BitmapMorph'+this.id+'.nextStep()', 1);
	}
	else {
		this.finish();
		this.fireOnStop();
	}
}

function BitmapMorph_finish() {
//	this.source.show(false);
//	this.target.show(true);
}

function BitmapMorph_fireOnStop() {
}

function BitmapMorph_fireOnPlay() {
}

//+----------------------------------------------------------------------------
function Point(x, y) {
	this.x					= x;
	this.y					= y;
	
	this.distance		= Point_distance;
	this.toString		= Point_toString;
}

function Point_distance(point) {
	var d = Math.sqrt(((this.x-point.x)*(this.x-point.x)) + 
										((this.y-point.y)*(this.y-point.y)));
	return d;
}

function Point_toString() {
	return "(" + this.x + "," + this.y + ")";
}